-- Aby móc uruchomić ten przykład, upewnij się najpierw, że 
-- uruchomiłeś wcześniej SalesOrdersStructure.sql i
-- SalesOrdersData.sql w katalogu z bazami przykładowymi  

USE SalesOrdersSample;
GO

-- Listing 8.4 Alternatywne podejście do wyświetlania wszystkich klientów i wszystkich produktów, z oznaczeniem które produkty zostały zamówione przez klienta

SELECT C.CustomerID, C.CustFirstName, C.CustLastName,
  P.ProductNumber, P.ProductName,
  (CASE WHEN C.CustomerID IN
    (SELECT Orders.CustomerID
     FROM Orders INNER JOIN Order_Details
       ON Orders.OrderNumber = Order_Details.OrderNumber
     WHERE Order_Details.ProductNumber = P.ProductNumber)
     THEN 'Zakupiłeś to!'
     ELSE ' ' 
  END) AS ProductOrdered
FROM Customers AS C, Products AS P
ORDER BY C.CustomerID, P.ProductName;
